<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Attendance;
use App\Models\Evaluation;
use App\Models\Feedback;


use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     *
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }



    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

     public function index()
     {
         $user = auth()->user();

         if ($user->role == 'admin') {
             $totalStudents = User::where('role', 'student')->count();
             $totalSupervisors = User::where('role', 'supervisor')->count();
             $approvedLogbooks = User::where('logbook_approved', true)->count();
             $pendingApprovals = User::where('role', 'student')->where('logbook_approved', false)->count();

             return view('home', compact('totalStudents', 'totalSupervisors', 'approvedLogbooks', 'pendingApprovals'));
         }

         if ($user->role == 'supervisor') {
             $assignedStudents = User::where('supervisor_id', $user->id)->count();
             $completedEvaluations = Evaluation::where('supervisor_id', $user->id)->count();

             return view('home', compact('assignedStudents', 'completedEvaluations'));
         }

         if ($user->role == 'student') {
             $daysAttended = Attendance::where('student_id', $user->id)->count();

             // Get the latest evaluation remark for the student
             $latestEvaluation = \App\Models\Evaluation::where('student_id', $user->id)
                 ->latest()
                 ->first();

             $feedbackReceived = $latestEvaluation?->remarks ?? 'No remarks yet';

             return view('home', compact('daysAttended', 'feedbackReceived'));
         }
     }


}
