<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Attendance;
use App\Models\LogbookEntry;
use App\Models\Evaluation;

class StudentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $students = User::where('role', 'student')->get(); // assuming role is stored like this
        return view('admin.students.index', compact('students'));
    }

    public function showAssignForm(User $student)
    {
        $supervisors = User::where('role', 'supervisor')->get();
        return view('admin.students.assign', compact('student', 'supervisors'));
    }

    public function assignSupervisor(Request $request, User $student)
{
    $request->validate([
        'supervisor_id' => 'nullable|exists:users,id' // nullable means it can be 'None'
    ]);

    $student->supervisor_id = $request->supervisor_id; // can be null
    $student->save();

    return redirect()->route('admin.students.index')->with('success', 'Supervisor updated successfully.');
}

public function showLogbook()
{
    $student = auth()->user();

    $attendances = Attendance::where('student_id', $student->id)->get();
    $logbookEntries = Attendance::where('student_id', $student->id)->get();

    $evaluation = Evaluation::where('student_id', $student->id)->first();

    return view('students.logbook', compact('attendances', 'evaluation', 'attendances', 'logbookEntries'));
}

public function toggleLogbookApproval(User $student)
{
    $student->logbook_approved = !$student->logbook_approved;
    $student->save();

    $message = $student->logbook_approved
        ? 'Logbook approved successfully!'
        : 'Logbook approval has been cancelled.';

    return back()->with('success', $message);
}





}
