@extends('layouts.dash')

@section('content')
    <h1>All Students</h1>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Supervisor</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($students as $student)
                <tr>
                    <td>{{ $student->name }}</td>
                    <td>{{ $student->email }}</td>
                    <td>{{ $student->supervisor?->name ?? 'None' }}</td>
                    <td>
                        <a href="{{ route('admin.students.assign.form', $student->id) }}" class="btn btn-primary btn-sm">
                            {{ $student->supervisor ? 'Change Supervisor' : 'Assign Supervisor' }}
                        </a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
