@extends('layouts.dash')

@section('content')
@include('inc.header')
    <h2>All Supervisors</h2>
    <table class="table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                {{-- <th>Department</th> --}}
                <th>Students Assigned</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($supervisors as $supervisor)
                <tr>
                    <td>{{ $supervisor->name }}</td>
                    <td>{{ $supervisor->email }}</td>
                    {{-- <td>{{ $supervisor->department }}</td> --}}
                    <td>{{ $supervisor->students->count() }}</td>
                    <td>
                        <a href="{{ route('admin.supervisors.students', $supervisor->id) }}" class="btn btn-info btn-sm">View All Students</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
