@extends('layouts.dash')

@section('content')
@include('inc.header')
    <h3>Students under Supervisor: {{ $supervisor->name }}</h3>

    @if($supervisor->students->isEmpty())
        <p>No students assigned yet.</p>
    @else
        <table class="table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Matric</th>
                    <th>Level</th>
                    <th>Email</th>
                    <th>Department</th>
                </tr>
            </thead>
            <tbody>
                @foreach($supervisor->students as $student)
                    <tr>
                        <td>{{ $student->name }}</td>
                        <td>{{ $student->matric }}</td>
                        <td>{{ $student->level }}</td>
                        <td>{{ $student->email }}</td>
                        <td>{{ $student->department }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
@endsection
