@extends('layouts.dash')

@section('content')
<div class="container my-5">
    {{-- Supervisor: Select a student --}}
    @if(auth()->user()->role == 'supervisor')
        <div class="card mb-4">
            <div class="card-header">🎯 Select a Student</div>
            <div class="card-body">
                <form method="GET" action="{{ route('attendance.mark') }}">
                    <div class="mb-3">
                        <select name="student_id" class="form-select" onchange="this.form.submit()">
                            <option value="">-- Select Student --</option>
                            @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ request('student_id') == $student->id ? 'selected' : '' }}>
                                    {{ $student->name }} ({{ $student->matric }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </form>
            </div>
        </div>
    @endif

    {{-- Only show attendance history and form if a student is selected or if user is student --}}
    @if(auth()->user()->role == 'student' || request('student_id'))
        {{-- Attendance History --}}
        <div class="card mb-4">
            <div class="card-header">📜 Attendance History</div>
            <div class="card-body p-0">
                @if($attendances->isEmpty())
                    <div class="p-4 text-center text-muted">
                        No attendance records yet.
                    </div>
                @else
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Lesson Learned</th>
                                    <th>Diagram</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($attendances as $attendance)
                                    <tr>
                                        <td>{{ \Carbon\Carbon::parse($attendance->date)->format('M d, Y') }}</td>
                                        <td>{{ Str::limit($attendance->lesson_learned, 50) }}</td>
                                        <td>

                                            @if($attendance->diagram_path)
                                            <img width="70" height="40" src="{{ Storage::url($attendance->diagram_path) }}" style="max-width: 150px;">
                                        @else
                                            <span class="text-muted">No Diagram</span>
                                        @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

        {{-- Form for marking attendance --}}
        <div class="card">
            <div class="card-header">📅 Mark Attendance</div>

            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif

                <form action="{{ route('attendance.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    {{-- Only supervisors need to include student_id --}}
                    @if(auth()->user()->role == 'supervisor')
                        <input type="hidden" name="student_id" value="{{ request('student_id') }}">
                    @endif

                    <div class="mb-3">
                        <label for="date" class="form-label">Date of Attendance</label>
                        <input type="date" class="form-control" id="date" name="date" value="{{ old('date') }}" required>
                        @error('date') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="lesson_learned" class="form-label">Lessons Learned</label>
                        <textarea class="form-control" id="lesson_learned" name="lesson_learned" rows="4" required>{{ old('lesson_learned') }}</textarea>
                        @error('lesson_learned') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="diagram" class="form-label">Upload Diagram (Optional)</label>
                        <input class="form-control" type="file" id="diagram" name="diagram" accept="image/*">
                        @error('diagram') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>

                    <button type="submit" class="btn btn-primary">✅ Submit Attendance</button>
                </form>
            </div>
        </div>
    @else
        {{-- If no student selected yet --}}
        @if(auth()->user()->role == 'supervisor')
            <div class="alert alert-info">
                Please select a student to begin marking attendance.
            </div>
        @endif
    @endif
</div>
@endsection
