<?php
    $user = Auth::user();
    $historyCount = optional($user->histories)->count() ?? 0;
    $histories = $user->histories ?? collect(); // Ensure it's always a collection
    $messageCount = optional($user->messages)->count() ?? 0;
?>

<!-- Topbar -->
<nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

    <!-- Sidebar Toggle (Topbar) -->
    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
        <i class="fa fa-bars"></i>
    </button>

    {{-- <!-- Search Bar (Optional) -->
    <form class="d-none d-sm-inline-block form-inline mr-auto ml-md-3 my-2 my-md-0 mw-100 navbar-search">
        <div class="input-group">
            <input type="text" class="form-control bg-light border-0 small" placeholder="Search for..."
                aria-label="Search" aria-describedby="basic-addon2">
            <div class="input-group-append">
                <button class="btn btn-primary" type="button">
                    <i class="fas fa-search fa-sm"></i>
                </button>
            </div>
        </div>
    </form>
    --}}

    <!-- Topbar Navbar -->
    <ul class="navbar-nav ml-auto">

        {{-- <!-- Notifications (Alerts) -->
        <li class="nav-item dropdown no-arrow mx-1">
            <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="fas fa-bell fa-fw"></i>
                @if($historyCount > 0)
                    <span class="badge badge-danger badge-counter">{{ $historyCount }}</span>
                @endif
            </a>
            <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
                aria-labelledby="alertsDropdown">
                <h6 class="dropdown-header">Alerts Center</h6>
                @foreach($histories->take(5) as $history)
                    <a class="dropdown-item d-flex align-items-center" href="#">
                        <div class="mr-3">
                            <div class="icon-circle bg-primary">
                                <i class="fas fa-info text-white"></i>
                            </div>
                        </div>
                        <div>
                            <div class="small text-gray-500">{{ $history->created_at->format('F d, Y') }}</div>
                            <span class="font-weight-bold">{{ $history->message }}</span>
                        </div>
                    </a>
                @endforeach
                <a class="dropdown-item text-center small text-gray-500" href="#">Show All Alerts</a>
            </div>
        </li>
        --}}

        {{-- <!-- Messages -->
        <li class="nav-item dropdown no-arrow mx-1">
            <a class="nav-link" href="{{ route('messages.index') }}">
                <i class="fas fa-envelope fa-fw"></i>
                @if($messageCount > 0)
                    <span class="badge badge-danger badge-counter">{{ $messageCount }}</span>
                @endif
            </a>
        </li>
        --}}

        <!-- Divider -->
        <div class="topbar-divider d-none d-sm-block"></div>

        <!-- User Info Dropdown -->
        <li class="nav-item dropdown no-arrow">
            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="mr-2 d-none d-lg-inline text-gray-600 small">{{ $user->name }}</span>
                <img class="img-profile rounded-circle"
                    src="{{ $user->image ? asset($user->image) : asset('img/default-profile.png') }}">
            </a>
            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                aria-labelledby="userDropdown">
                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                    Logout
                </a>
            </div>
        </li>

    </ul>
</nav>
<!-- End of Topbar -->
