@extends('layouts.dash')

@section('content')
@include('inc.header')

@push('styles')
<style>
    body {
        font-family: 'Poppins', sans-serif;
    }
    .card {
        background: #ffffff;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        margin-bottom: 30px;
    }
    .card-header {
        font-size: 1.5rem;
        font-weight: bold;
        color: #004085;
        margin-bottom: 20px;
    }
    .summary-list {
        list-style: none;
        padding-left: 0;
    }
    .summary-list li {
        margin-bottom: 10px;
    }
    .badge {
        border-radius: 20px;
        padding: 6px 12px;
        font-size: 0.9rem;
    }
    .badge-excellent { background-color: #28a745; color: white; }
    .badge-good { background-color: #ffc107; color: black; }
    .badge-low { background-color: #dc3545; color: white; }
    .recent-entries table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 8px;
    }
    .recent-entries th, .recent-entries td {
        background: #f9f9f9;
        padding: 15px;
        border: none;
    }
    .recent-entries th {
        background: #e9ecef;
    }
</style>
@endpush

<div class="container my-4">

    <div class="card">
        <div class="card-header">📘 My Internship Logbook</div>

        {{-- Attendance and Summary --}}
        <div class="row">
            <div class="col-md-6">
                <h4>{{ auth()->user()->name }}</h4>
                <p><strong>MATRIC NO:</strong> {{ Auth::user()->matric }}</p>
            </div>
            <div class="col-md-6 text-end">
                @php
                    $attendanceCount = $attendances->count();
                    $lessonCount = $attendances->count();
                    $diagramCount = $attendances->whereNotNull('diagram_path')->count();
                    $attendanceScore = $attendanceCount / 7;

                    if ($attendanceScore < 5) {
                        $badgeClass = 'badge-low';
                        $status = '❌ Dangerously Low Attendance!';
                    } elseif ($attendanceScore == 5) {
                        $badgeClass = 'badge-good';
                        $status = '⚠️ Good Attendance!';
                    } else {
                        $badgeClass = 'badge-excellent';
                        $status = '✅ Excellent Attendance!';
                    }
                @endphp

                <span class="badge {{ $badgeClass }}">
                    {{ $status }} ({{ number_format($attendanceScore, 1) }}/10)
                </span>
            </div>
        </div>

        <ul class="summary-list mt-3">
            <li><strong>Total Days Attended:</strong> {{ $attendanceCount }} days</li>
            <li><strong>Lessons Learned:</strong> {{ $lessonCount }} entries</li>
            <li><strong>Diagrams Uploaded:</strong> {{ $diagramCount }} diagrams</li>
        </ul>
    </div>

    {{-- Recent Entries --}}
    @if($attendances->isNotEmpty())
    <div class="card recent-entries">
        <div class="card-header">📝 My Logbook Entries</div>

        <table class="table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Work Done</th>
                    <th>Diagram</th>
                </tr>
            </thead>
            <tbody>
                @foreach($logbookEntries as $entry)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($entry->date)->format('D, M j, Y') }}</td>
                    <td>{{ \Illuminate\Support\Str::limit($entry->lesson_learned, 60) }}</td>
                    <td>
                        @if($entry->diagram_path)
                            <img src="{{ asset('storage/' . $entry->diagram_path) }}" alt="Diagram" width="80">
                        @else
                            <span class="text-muted">No Diagram</span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
        <div class="alert alert-info">
            You don't have any logbook entries yet!
        </div>
    @endif

    {{-- Evaluation Summary --}}
    @if($evaluation)
    <div class="card">
        <div class="card-header">📋 Supervisor's Evaluation</div>
        <ul class="summary-list">
            <li><strong>Punctuality:</strong> {{ $evaluation->punctuality }}/10</li>
            <li><strong>Attitude:</strong> {{ $evaluation->attitude }}/10</li>
            <li><strong>Skill Acquisition:</strong> {{ $evaluation->skill_acquisition }}/10</li>
            <li><strong>Report Quality:</strong> {{ $evaluation->report_quality }}/10</li>
            <li><strong>Remarks:</strong> {{ $evaluation->remarks ?? 'No remarks provided' }}</li>
        </ul>
    </div>
    @endif

</div>
@endsection
