@extends('layouts.dash')

@section('content')
@include('inc.header')

<h2>My Assigned Students</h2>
<p><strong>Date:</strong> {{ \Carbon\Carbon::now()->format('l, F j, Y') }}</p>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<table class="table table-bordered">
    <thead>
        <tr>
            <th>Student Name</th>
            <th>Email</th>
            <th>Mark Attendance</th>
            <th>Lesson Learned</th>
        </tr>
    </thead>
    <tbody>
        @php
            $today = \Carbon\Carbon::now()->toDateString();
        @endphp

        @foreach($students as $student)
            @php
                $attendance = $attendances->where('student_id', $student->id)
                                          ->where('date', $today)
                                          ->first();
            @endphp

            <tr>
                <td>{{ $student->name }}</td>
                <td>{{ $student->email }}</td>

                {{-- Mark Attendance --}}
                <td>
                    @if($attendance)
                        <span class="badge bg-success">Marked</span>
                    @else
                        <form method="POST" action="{{ route('students.attendance.mark', $student->id) }}">
                            @csrf
                            <button type="submit" class="btn btn-success btn-sm">✔️ Mark</button>
                        </form>
                    @endif
                </td>

                {{-- Lesson Learned (always editable) --}}
                <td>
                    <form method="POST" action="{{ route('students.attendance.mark', $student->id) }}">
                        @csrf
                        <input
                            type="text"
                            name="lesson_learned"
                            class="form-control mb-1"
                            placeholder="E.g. Learnt PHP classes"
                            value="{{ $attendance->lesson_learned ?? '' }}"
                        >
                        <button type="submit" class="btn btn-info btn-sm">
                            {{ $attendance ? 'Update Lesson' : 'Save Lesson' }}
                        </button>
                    </form>
                    @if($attendance && !$attendance->lesson_learned)
                        <small class="text-muted">No comments</small>
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
@endsection
