@extends('layouts.dash')

@section('content')
@include('inc.header')

<div class="container">
    <h2 class="mb-4">🗓️ Attendance Calendar</h2>

    {{-- Student Selector --}}
    <form method="GET" action="{{ route('attendance.records') }}">
        <div class="mb-3">
            <label class="form-label fw-bold">Select Student</label>
            <select name="student_id" onchange="this.form.submit()" class="form-control">
                <option value="">-- Choose Student --</option>
                @foreach($students as $s)
                    <option value="{{ $s->id }}" {{ request('student_id') == $s->id ? 'selected' : '' }}>
                        {{ $s->name }}
                    </option>
                @endforeach
            </select>
        </div>
    </form>

    @if($selectedStudent)
        <div class="mb-4">
            <h4 class="fw-bold">{{ $selectedStudent->name }} - {{ now()->format('F Y') }}</h4>
        </div>

        <form method="POST" action="{{ route('attendance.update', $selectedStudent->id) }}">
            @csrf
            @method('PUT')

            {{-- Calendar Table --}}
            <div class="table-responsive">
                <table class="table table-bordered text-center">
                    <thead class="table-light">
                        <tr>
                            @foreach(['Mon','Tue','Wed','Thu','Fri','Sat','Sun'] as $day)
                                <th>{{ $day }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($calendar as $week)
                            <tr>
                                @foreach($week as $day)
                                    <td class="{{ !$day['in_month'] ? 'bg-light' : '' }}">
                                        @if($day['in_month'])
                                            <label class="d-block">
                                                <input
                                                    type="checkbox"
                                                    name="attendance_dates[]"
                                                    value="{{ $day['date']->format('Y-m-d') }}"
                                                    {{ in_array($day['date']->format('Y-m-d'), $presentDays) ? 'checked' : '' }}
                                                >
                                                <br>
                                                <small>{{ $day['date']->format('d') }}</small> {{-- Small date format --}}
                                            </label>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary mt-3">
                    💾 Update Attendance
                </button>
            </div>
        </form>
    @endif
</div>
@endsection
