<form method="GET" action="{{ route('evaluations.edit') }}">
    <label>Select Student</label>
    <select name="student_id" class="form-control" onchange="this.form.submit()">
        <option value="">-- Choose --</option>
        @foreach($students as $s)
            <option value="{{ $s->id }}" {{ request('student_id') == $s->id ? 'selected' : '' }}>{{ $s->name }}</option>
        @endforeach
    </select>
</form>

@if(request('student_id'))
    @php
        $student = \App\Models\User::find(request('student_id'));
        $alreadyEvaluated = \App\Models\Evaluation::where('student_id', $student->id)->exists();
        $hasAttendance = \App\Models\Attendance::where('student_id', $student->id)->exists();
    @endphp

    @if($alreadyEvaluated)
        <div class="alert alert-warning mt-3">
            This student has already been evaluated. <a href="{{ route('evaluations.edit', $student->id) }}">Click here to edit evaluation.</a>
        </div>
    @elseif(!$hasAttendance)
        <div class="alert alert-danger mt-3">
            Student has no attendance records to be evaluated!
        </div>
    @else
        {{-- Show evaluation form --}}
        <form method="POST" action="{{ route('evaluations.store') }}">
            @csrf
            <input type="hidden" name="student_id" value="{{ $student->id }}">

            <div class="form-group mt-3">
                <label>Technical Skills</label>
                <input type="number" class="form-control" name="technical_skills" required max="100">
            </div>
            <div class="form-group">
                <label>Communication</label>
                <input type="number" class="form-control" name="communication" required max="100">
            </div>
            <div class="form-group">
                <label>Teamwork</label>
                <input type="number" class="form-control" name="teamwork" required max="100">
            </div>
            <div class="form-group">
                <label>Reliability</label>
                <input type="number" class="form-control" name="reliability" required max="100">
            </div>
            <button type="submit" class="btn btn-primary mt-2">Submit Evaluation</button>
        </form>
    @endif
@endif
