@extends('layouts.dash')

@section('content')
@include('inc.header')

<div class="container mt-4">
    <h3>Edit Evaluation for {{ $evaluation->student->name ?? 'Unknown Student' }}</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif


    <form method="POST" action="{{ route('evaluation.update', $evaluation->id) }}">
        @csrf

        <div class="mb-3"><label>Punctuality</label><input type="number" value="{{ $evaluation->punctuality }}" name="punctuality" class="form-control" max="10" required></div>
        <div class="mb-3"><label>Attitude</label><input type="number" name="attitude" value="{{ $evaluation->attitude }}" class="form-control" max="10" required></div>
        <div class="mb-3"><label>Skill Acquisition</label><input type="number" name="skill_acquisition" value="{{ $evaluation->skill_acquisition }}" class="form-control" max="10" required></div>
        <div class="mb-3"><label>Report Quality</label><input type="number" name="report_quality" value="{{ $evaluation->report_quality }}" class="form-control" max="10" required></div>

        <div class="mb-3">
            <label for="comments" class="form-label">Comments</label>
            <textarea name="remarks" id="comments" class="form-control" rows="4">{{ $evaluation->comments }}</textarea>
        </div>

        <button type="submit" class="btn btn-primary">Update Evaluation</button>
        <a href="{{ route('evaluations.index') }}" class="btn btn-secondary">Back</a>
    </form>
</div>
@endsection
