@extends('layouts.dash')

@section('content')
@include('inc.header')

@push('styles')
<style>
    body {
        font-family: 'Poppins', sans-serif;
    }
    .card {
        background: #ffffff;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        margin-bottom: 30px;
    }
    .card-header {
        font-size: 1.5rem;
        font-weight: 600;
        color: #004085;
        margin-bottom: 20px;
    }
    .summary-list {
        list-style: none;
        padding: 0;
    }
    .summary-list li {
        margin-bottom: 10px;
        font-size: 1rem;
    }
    .badge {
        border-radius: 20px;
        padding: 6px 12px;
        font-size: 0.9rem;
        display: inline-block;
    }
    .badge-excellent { background-color: #28a745; color: white; }
    .badge-good { background-color: #ffc107; color: black; }
    .badge-low { background-color: #dc3545; color: white; }
    .recent-entries table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 8px;
    }
    .recent-entries th, .recent-entries td {
        background: #f9f9f9;
        padding: 15px;
        border: none;
    }
    .recent-entries th {
        background: #e9ecef;
    }
</style>
@endpush

<div class="container my-4">

    <div class="card">
        <div class="card-header">📘 Internship Logbook Overview</div>

        <form method="GET" action="{{ route('supervisor.viewLogbook') }}">
            <div class="row g-3 align-items-end">
                <div class="col-md-8">
                    <label for="student_id" class="form-label">Select Student</label>
                    <select name="student_id" id="student_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- Choose a student --</option>
                        @foreach($students as $s)
                            <option value="{{ $s->id }}" {{ request('student_id') == $s->id ? 'selected' : '' }}>
                                {{ $s->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 text-end">
                    @if($selectedStudent)
                        <button class="btn btn-primary" onclick="window.print()">🖨️ Print</button>
                    @endif
                </div>
            </div>
        </form>

        @if($selectedStudent)
        <hr class="my-4">

        {{-- Student Summary --}}
        <div class="row">
            <div class="col-md-6">
                <h4>{{ $selectedStudent->name }}</h4>
                <p><strong>ID:</strong> {{ $selectedStudent->id }}</p>
            </div>
            <div class="col-md-6 text-end">
                @php
                    $attendanceCount = $attendances->count();
                    $lessonCount = $logbookEntries->count();
                    $diagramCount = $logbookEntries->whereNotNull('diagram_path')->count();

                    $attendanceScore = $attendanceCount / 7;

                    if ($attendanceScore < 5) {
                        $badgeClass = 'badge-low';
                        $status = '❌ Dangerously Low Attendance!';
                    } elseif ($attendanceScore == 5) {
                        $badgeClass = 'badge-good';
                        $status = '⚠️ Good Attendance!';
                    } else {
                        $badgeClass = 'badge-excellent';
                        $status = '✅ Excellent Attendance!';
                    }
                @endphp

                <span class="badge {{ $badgeClass }}">
                    {{ $status }} ({{ number_format($attendanceScore, 1) }}/10)
                </span>
            </div>
        </div>

        {{-- Overall Summary --}}
        <ul class="summary-list mt-3">
            <li><strong>Total Days Attended:</strong> {{ $attendanceCount }} days</li>
            <li><strong>Lessons Learned:</strong> {{ $lessonCount }} entries</li>
            <li><strong>Diagrams Uploaded:</strong> {{ $diagramCount }} diagrams</li>
        </ul>

        @endif
    </div>

    {{-- Recent Entries --}}
    @if($selectedStudent && $logbookEntries->isNotEmpty())
    <div class="card recent-entries">
        <div class="card-header">📝 Recent Logbook Entries</div>

        <table class="table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Work Done</th>
                    <th>Diagram</th>
                </tr>
            </thead>
            <tbody>
                @foreach($logbookEntries->take(5) as $entry)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($entry->date)->format('D, M j, Y') }}</td>
                    <td>{{ \Illuminate\Support\Str::limit($entry->lesson_learned, 60) }}</td>
                    <td>
                        @if($entry->diagram_path)
                            <img src="{{ asset('storage/' . $entry->diagram_path) }}" alt="Diagram" width="80">
                        @else
                            <span class="text-muted">No Diagram</span>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

    </div>
    @endif

    {{-- Evaluation Summary --}}
    @if($evaluation)
    <div class="card">
        <div class="card-header">📋 Evaluation Summary</div>

        <ul class="summary-list">
            <li><strong>Punctuality:</strong> {{ $evaluation->punctuality }}/10</li>
            <li><strong>Attitude:</strong> {{ $evaluation->attitude }}/10</li>
            <li><strong>Skill Acquisition:</strong> {{ $evaluation->skill_acquisition }}/10</li>
            <li><strong>Report Quality:</strong> {{ $evaluation->report_quality }}/10</li>
            <li><strong>Remarks:</strong> {{ $evaluation->remarks ?? 'No remarks' }}</li>
        </ul>
    </div>
    @endif

    @if(Auth::user()->role == 'admin')
    @if($selectedStudent->logbook_approved != Null)
    <div class="alert alert-success mt-3">
        <strong>Status:</strong> Logbook Approved ✅
    </div>
@endif

    <form method="POST" action="{{ route('admin.toggleLogbookApproval', $selectedStudent->id) }}">
        @csrf
        <button type="submit" class="btn btn-{{ $selectedStudent->logbook_approved ? 'danger' : 'success' }} btn-lg">
            {{ $selectedStudent->logbook_approved ? '❌ Cancel Approval' : '✅ Approve Logbook' }}
        </button>
    </form>

@endif
</div>

@endsection
