<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\SupervisorController;
use App\Http\Controllers\OrganizationController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\LogbookController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\EvaluationController;
use App\Http\Controllers\FeedbackController;
use App\Http\Controllers\PlacementController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MessageController;

// Home Route
Route::get('/', function () {
    return view('welcome');
});



// Auth Routes
Auth::routes();

Route::middleware(['auth'])->prefix('admin')->group(function () {
    Route::get('/supervisors', [SupervisorController::class, 'index'])->name('admin.supervisors.index');
    Route::get('/supervisors/{id}/students', [SupervisorController::class, 'showStudents'])->name('admin.supervisors.students');
});


// Dashboard Route (Common for all users)
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
Route::get('/messages', [MessageController::class, 'index'])->name('messages.index');

Route::put('/supervisor/logbook/update/{entry}', [SupervisorController::class, 'updateLogbookEntry'])->name('supervisor.updateLogbookEntry');

// Admin Routes

Route::middleware(['auth'])->group(function () {
    // Other supervisor routes...

    // Custom routes for evaluations
    Route::get('evaluations', [EvaluationController::class, 'index'])->name('evaluations.index');
    Route::get('/evaluations/create', [EvaluationController::class, 'create'])->name('evaluations.create');
    Route::post('/evaluations/store', [EvaluationController::class, 'store'])->name('evaluations.store');
    Route::get('/evaluations/{id}/edit', [EvaluationController::class, 'edit'])->name('evaluations.edit');
    // Route::put('/evaluations/{id}', [EvaluationController::class, 'update'])->name('evaluations.update');
    Route::post('/eval/update/student/{id}', [EvaluationController::class, 'update'])->name('evaluation.update');
});



Route::prefix('admin')->middleware(['auth'])->group(function () {
    Route::get('/students', [StudentController::class, 'index'])->name('admin.students.index');


    Route::put('/students/{student}/assign-supervisor', [StudentController::class, 'assignSupervisor'])->name('admin.students.assign.update');

    Route::get('/students/{student}/assign-supervisor', [StudentController::class, 'showAssignForm'])->name('admin.students.assign.form');
    Route::post('/students/{student}/assign-supervisor', [StudentController::class, 'assignSupervisor'])->name('admin.students.assign');

    Route::get('/supervisor/logbook', [SupervisorController::class, 'viewLogbook'])->name('supervisor.viewLogbook');
    Route::post('/supervisor/logbook/{student}/upload-diagram', [SupervisorController::class, 'uploadDiagram'])->name('supervisor.uploadDiagram');

});

Route::middleware(['auth'])->group(function () {
    Route::resource('students', StudentController::class);
    Route::resource('supervisors', SupervisorController::class);
    Route::get('supervisors/assign', [SupervisorController::class, 'assign'])->name('supervisors.assign');
    Route::resource('organizations', OrganizationController::class);

    Route::get('reports/generate', [ReportController::class, 'generate'])->name('reports.generate');
    Route::post('reports/submit', [ReportController::class, 'submit'])->name('reports.submit');

    Route::get('logbooks/approve', [LogbookController::class, 'approve'])->name('logbooks.approve');
});


Route::post('/admin/students/{student}/approve-logbook', [StudentController::class, 'approveLogbook'])
    ->name('admin.approveLogbook');

    Route::post('/students/{student}/toggle-approval', [StudentController::class, 'toggleLogbookApproval'])
    ->name('admin.toggleLogbookApproval');

// Supervisor Routes
Route::middleware(['auth'])->group(function () {

    Route::get('supervor/students/assigned', [SupervisorController::class, 'assignedStudents'])->name('students.assigned');
    Route::post('students/{id}/attendance', [SupervisorController::class, 'markAttendance'])->name('students.attendance.mark');
    // Supervisor and Student routes
    Route::get('/attendance/mark', [AttendanceController::class, 'showAttendanceForm'])->name('attendance.mark');
    Route::post('/attendance/mark', [AttendanceController::class, 'markAttendance'])->name('attendance.mark.submit');

    Route::post('/attendance/store', [AttendanceController::class, 'store'])->name('attendance.store');
    Route::get('attendance/records', [AttendanceController::class, 'records'])->name('attendance.records');
    Route::put('attendance/update/{studentId}', [AttendanceController::class, 'update'])->name('attendance.update');


    // Route::resource('evaluations', EvaluationController::class);
    Route::resource('feedback', FeedbackController::class);
});

// Student Routes
Route::middleware(['auth'])->group(function () {
    Route::get('logbooks/show', [StudentController::class, 'showLogbook'])->name('logbooks.show');
    Route::post('reports/submit', [ReportController::class, 'submit'])->name('reports.submit');

    Route::get('placement/request', [PlacementController::class, 'request'])->name('placement.request');
    Route::get('feedback/view', [FeedbackController::class, 'view'])->name('feedback.view');

    Route::get('documents/download', [DocumentController::class, 'download'])->name('documents.download');
});

// Home Route after Login
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
