<?php $__env->startSection('content'); ?>
<?php echo $__env->make('inc.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="container py-4">
    <h2 class="mb-4">🎯 Evaluate Students</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        
        <div class="col-md-6">
            <form method="GET" action="<?php echo e(route('evaluations.index')); ?>">
                <label for="student_id" class="form-label">Select Student</label>
                <select name="student_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Choose a student --</option>
                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $hasAttendance = \App\Models\Attendance::where('student_id', $student->id)->exists();
                            $alreadyEvaluated = \App\Models\Evaluation::where('student_id', $student->id)->exists();
                        ?>
                        <option value="<?php echo e($student->id); ?>"
                            <?php if(!$hasAttendance || $alreadyEvaluated): ?> disabled <?php endif; ?>
                            <?php if(request('student_id') == $student->id): ?> selected <?php endif; ?>>
                            <?php echo e($student->name); ?>

                            <?php if(!$hasAttendance): ?> - No Attendance
                            <?php elseif($alreadyEvaluated): ?> - Already Evaluated
                            <?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </form>

            <?php if(request('student_id')): ?>
                <?php
                    $student = \App\Models\User::find(request('student_id'));
                    $hasAttendance = \App\Models\Attendance::where('student_id', $student->id)->exists();
                    $alreadyEvaluated = \App\Models\Evaluation::where('student_id', $student->id)->first();
                ?>

                <?php if(!$hasAttendance): ?>
                    <div class="alert alert-danger mt-3">
                        Student has no attendance records to be evaluated!
                    </div>
                <?php elseif($alreadyEvaluated): ?>
                    <div class="alert alert-warning mt-3 d-flex justify-content-between align-items-center">
                        <span>Student has already been evaluated.</span>
                        <a href="<?php echo e(route('evaluations.edit', $alreadyEvaluated->id)); ?>" class="btn btn-sm btn-outline-primary">Edit Evaluation</a>
                    </div>
                <?php else: ?>
                    <form method="POST" action="<?php echo e(route('evaluations.store')); ?>" class="mt-4">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="student_id" value="<?php echo e($student->id); ?>">

                        <div class="mb-3">
                            <label>Punctuality</label>
                            <input type="number" name="punctuality" class="form-control <?php $__errorArgs = ['punctuality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" max="10" value="<?php echo e(old('punctuality')); ?>" required>
                            <?php $__errorArgs = ['punctuality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label>Attitude</label>
                            <input type="number" name="attitude" class="form-control <?php $__errorArgs = ['attitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" max="10" value="<?php echo e(old('attitude')); ?>" required>
                            <?php $__errorArgs = ['attitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label>Skill Acquisition</label>
                            <input type="number" name="skill_acquisition" class="form-control <?php $__errorArgs = ['skill_acquisition'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" max="10" value="<?php echo e(old('skill_acquisition')); ?>" required>
                            <?php $__errorArgs = ['skill_acquisition'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label>Report Quality</label>
                            <input type="number" name="report_quality" class="form-control <?php $__errorArgs = ['report_quality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" max="10" value="<?php echo e(old('report_quality')); ?>" required>
                            <?php $__errorArgs = ['report_quality'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label>Remarks</label>
                            <textarea name="remarks" class="form-control <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3" placeholder="Optional remarks..."><?php echo e(old('remarks')); ?></textarea>
                            <?php $__errorArgs = ['remarks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <button class="btn btn-primary w-100">💾 Submit Evaluation</button>
                    </form>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        
        <div class="col-md-6">
            <h5 class="mb-3">📊 Average Evaluation Breakdown</h5>
            <canvas id="evaluationChart"></canvas>
        </div>
    </div>

    
    <div class="mt-5">
        <h4>📄 Past Evaluations</h4>
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Student</th>
                        <th>Punctuality</th>
                        <th>Attitude</th>
                        <th>Skill</th>
                        <th>Report</th>
                        <th>Remarks</th>
                        <th>Updated</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $evaluations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($eval->student->name); ?></td>
                            <td><?php echo e($eval->punctuality); ?></td>
                            <td><?php echo e($eval->attitude); ?></td>
                            <td><?php echo e($eval->skill_acquisition); ?></td>
                            <td><?php echo e($eval->report_quality); ?></td>
                            <td><?php echo e($eval->remarks ?? '-'); ?></td>
                            <td><?php echo e($eval->updated_at->diffForHumans()); ?></td>
                            <td>

                                <a href="<?php echo e(route('evaluations.edit', $eval->id)); ?>" class="btn btn-sm btn-warning">
                                    <i class="bi bi-pencil"></i> Edit
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="8" class="text-center">No evaluations found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<script>
    const ctx = document.getElementById('evaluationChart');
    const chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Punctuality', 'Attitude', 'Skill', 'Report'],
            datasets: [{
                label: 'Avg Score',
                data: [
                    <?php echo e($averages['punctuality'] ?? 0); ?>,
                    <?php echo e($averages['attitude'] ?? 0); ?>,
                    <?php echo e($averages['skill_acquisition'] ?? 0); ?>,
                    <?php echo e($averages['report_quality'] ?? 0); ?>

                ],
                backgroundColor: ['#0d6efd', '#198754', '#ffc107', '#6f42c1']
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true,
                    max: 10
                }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Desktop\Laravel Projects\internmanager\resources\views/supervisors/evaluations/index.blade.php ENDPATH**/ ?>