<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Internship - Dashboard</title>

    <!-- Custom fonts for this template-->
    <link href="<?php echo e(asset('dash/vendor/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="<?php echo e(asset('dash/css/sb-admin-2.min.css')); ?>" rel="stylesheet">

</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div id="wrapper">
<?php if(Auth::check()): ?>
<!-- Sidebar -->
<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="<?php echo e(route('home')); ?>">
        <div class="sidebar-brand-icon rotate-n-15">
            <i class="fas fa-laugh-wink"></i>
        </div>
        <div class="sidebar-brand-text mx-3">SIWES Manager</div>
    </a>

    <!-- Divider -->
    <hr class="sidebar-divider my-0">

    <!-- Nav Item - Dashboard -->
    <li class="nav-item active">
        <a class="nav-link" href="<?php echo e(route('home')); ?>">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span></a>
    </li>

    <!-- Divider -->
    <hr class="sidebar-divider">

    <!-- Heading -->
    <div class="sidebar-heading">SIWES Management</div>

    <?php if(auth()->user()->role == 'admin'): ?>
        <!-- Admin: Manage Students -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('students.index')); ?>">
                <i class="fas fa-fw fa-users"></i>
                <span>All Students</span></a>
        </li>

        <!-- Admin: Manage Supervisors -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('supervisors.index')); ?>">
                <i class="fas fa-fw fa-user-tie"></i>
                <span>All Supervisors</span></a>
        </li>

        

        

        <!-- Admin: Generate Reports -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('supervisor.viewLogbook')); ?>">
                <i class="fas fa-fw fa-file-alt"></i>
                <span>View Logbooks</span></a>
        </li>


    <?php endif; ?>

    <?php if(auth()->user()->role == 'supervisor'): ?>
        <!-- Supervisor: View Assigned Students -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('students.assigned')); ?>">
                <i class="fas fa-fw fa-list"></i>
                <span>Assigned Students</span></a>
        </li>

        <!-- Supervisor: Mark Attendance -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('supervisor.viewLogbook')); ?>">
                <i class="fas fa-fw fa-calendar-check"></i>
                <span>View Students' Logbook</span></a>
        </li>

        <!-- Supervisor: Evaluate Students -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('evaluations.index')); ?>">
                <i class="fas fa-fw fa-star"></i>
                <span>Evaluate Students</span></a>
        </li>

        <!-- Supervisor: View Attendance Records -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('attendance.records')); ?>">
                <i class="fas fa-fw fa-clipboard-list"></i>
                <span>Attendance Records</span></a>
        </li>


    <?php endif; ?>

    <?php if(auth()->user()->role == 'supervisor'): ?>
    <!-- Supervisor: Mark Attendance -->
    <li class="nav-item">
        <a class="nav-link" href="<?php echo e(route('attendance.mark')); ?>">
            <i class="fas fa-fw fa-calendar-check"></i>
            <span>Mark Attendance</span>
        </a>
    </li>
<?php endif; ?>

    <?php if(auth()->user()->role == 'student'): ?>
        <!-- Student: View Logbook -->
        <!-- Supervisor: Mark Attendance -->
        <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('logbooks.show')); ?>">
                <i class="fas fa-fw fa-calendar-check"></i>
                <span>View My Logbook</span></a>
        </li>

        

        

        <!-- Student: View Supervisor Feedback -->
        

        <!-- Student: Download SIWES Documents -->
        
    <?php endif; ?>

    <!-- Divider -->
    <hr class="sidebar-divider d-none d-md-block">

    <!-- Sidebar Toggler (Sidebar) -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>

</ul>
<!-- End of Sidebar -->
<?php endif; ?>
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <?php echo $__env->yieldContent('content'); ?>
            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
                    <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Internship Portal &copy; <?php echo e(date('Y')); ?></span>
                </div>
            </div>
        </footer>

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <!-- Logout Modal -->
    <div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="logoutModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="logoutModalLabel">Ready to Leave?</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Click "Logout" to end your session.</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="<?php echo e(route('logout')); ?>"
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        Logout
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="<?php echo e(asset('dash/vendor/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dash/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Core plugin JavaScript -->
    <script src="<?php echo e(asset('dash/vendor/jquery-easing/jquery.easing.min.js')); ?>"></script>

    <!-- Custom scripts for all pages -->
    <script src="<?php echo e(asset('dash/js/sb-admin-2.min.js')); ?>"></script>

    <!-- Page level plugins -->
    <script src="<?php echo e(asset('dash/vendor/chart.js/Chart.min.js')); ?>"></script>

    <!-- Page level custom scripts -->
    <script src="<?php echo e(asset('dash/js/demo/chart-area-demo.js')); ?>"></script>
    <script src="<?php echo e(asset('dash/js/demo/chart-pie-demo.js')); ?>"></script>


</body>

</html>
<?php /**PATH C:\Users\HP\Desktop\Laravel Projects\internmanager\resources\views/layouts/dash.blade.php ENDPATH**/ ?>