<?php $__env->startSection('content'); ?>
<div class="container my-5">
    
    <?php if(auth()->user()->role == 'supervisor'): ?>
        <div class="card mb-4">
            <div class="card-header">🎯 Select a Student</div>
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('attendance.mark')); ?>">
                    <div class="mb-3">
                        <select name="student_id" class="form-select" onchange="this.form.submit()">
                            <option value="">-- Select Student --</option>
                            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($student->id); ?>" <?php echo e(request('student_id') == $student->id ? 'selected' : ''); ?>>
                                    <?php echo e($student->name); ?> (<?php echo e($student->matric); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>

    
    <?php if(auth()->user()->role == 'student' || request('student_id')): ?>
        
        <div class="card mb-4">
            <div class="card-header">📜 Attendance History</div>
            <div class="card-body p-0">
                <?php if($attendances->isEmpty()): ?>
                    <div class="p-4 text-center text-muted">
                        No attendance records yet.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Lesson Learned</th>
                                    <th>Diagram</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(\Carbon\Carbon::parse($attendance->date)->format('M d, Y')); ?></td>
                                        <td><?php echo e(Str::limit($attendance->lesson_learned, 50)); ?></td>
                                        <td>

                                            <?php if($attendance->diagram_path): ?>
                                            <img width="70" height="40" src="<?php echo e(Storage::url($attendance->diagram_path)); ?>" style="max-width: 150px;">
                                        <?php else: ?>
                                            <span class="text-muted">No Diagram</span>
                                        <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        
        <div class="card">
            <div class="card-header">📅 Mark Attendance</div>

            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>

                <form action="<?php echo e(route('attendance.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    
                    <?php if(auth()->user()->role == 'supervisor'): ?>
                        <input type="hidden" name="student_id" value="<?php echo e(request('student_id')); ?>">
                    <?php endif; ?>

                    <div class="mb-3">
                        <label for="date" class="form-label">Date of Attendance</label>
                        <input type="date" class="form-control" id="date" name="date" value="<?php echo e(old('date')); ?>" required>
                        <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="lesson_learned" class="form-label">Lessons Learned</label>
                        <textarea class="form-control" id="lesson_learned" name="lesson_learned" rows="4" required><?php echo e(old('lesson_learned')); ?></textarea>
                        <?php $__errorArgs = ['lesson_learned'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="diagram" class="form-label">Upload Diagram (Optional)</label>
                        <input class="form-control" type="file" id="diagram" name="diagram" accept="image/*">
                        <?php $__errorArgs = ['diagram'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <button type="submit" class="btn btn-primary">✅ Submit Attendance</button>
                </form>
            </div>
        </div>
    <?php else: ?>
        
        <?php if(auth()->user()->role == 'supervisor'): ?>
            <div class="alert alert-info">
                Please select a student to begin marking attendance.
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\HP\Desktop\Laravel Projects\internmanager\resources\views/attendance/mark.blade.php ENDPATH**/ ?>