<?php $__env->startSection('content'); ?>
<?php echo $__env->make('inc.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body {
        font-family: 'Poppins', sans-serif;
    }
    .card {
        background: #ffffff;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        margin-bottom: 30px;
    }
    .card-header {
        font-size: 1.5rem;
        font-weight: bold;
        color: #004085;
        margin-bottom: 20px;
    }
    .summary-list {
        list-style: none;
        padding-left: 0;
    }
    .summary-list li {
        margin-bottom: 10px;
    }
    .badge {
        border-radius: 20px;
        padding: 6px 12px;
        font-size: 0.9rem;
    }
    .badge-excellent { background-color: #28a745; color: white; }
    .badge-good { background-color: #ffc107; color: black; }
    .badge-low { background-color: #dc3545; color: white; }
    .recent-entries table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0 8px;
    }
    .recent-entries th, .recent-entries td {
        background: #f9f9f9;
        padding: 15px;
        border: none;
    }
    .recent-entries th {
        background: #e9ecef;
    }
</style>
<?php $__env->stopPush(); ?>

<div class="container my-4">

    <div class="card">
        <div class="card-header">📘 My Internship Logbook</div>

        
        <div class="row">
            <div class="col-md-6">
                <h4><?php echo e(auth()->user()->name); ?></h4>
                <p><strong>MATRIC NO:</strong> <?php echo e(Auth::user()->matric); ?></p>
            </div>
            <div class="col-md-6 text-end">
                <?php
                    $attendanceCount = $attendances->count();
                    $lessonCount = $attendances->count();
                    $diagramCount = $attendances->whereNotNull('diagram_path')->count();
                    $attendanceScore = $attendanceCount / 7;

                    if ($attendanceScore < 5) {
                        $badgeClass = 'badge-low';
                        $status = '❌ Dangerously Low Attendance!';
                    } elseif ($attendanceScore == 5) {
                        $badgeClass = 'badge-good';
                        $status = '⚠️ Good Attendance!';
                    } else {
                        $badgeClass = 'badge-excellent';
                        $status = '✅ Excellent Attendance!';
                    }
                ?>

                <span class="badge <?php echo e($badgeClass); ?>">
                    <?php echo e($status); ?> (<?php echo e(number_format($attendanceScore, 1)); ?>/10)
                </span>
            </div>
        </div>

        <ul class="summary-list mt-3">
            <li><strong>Total Days Attended:</strong> <?php echo e($attendanceCount); ?> days</li>
            <li><strong>Lessons Learned:</strong> <?php echo e($lessonCount); ?> entries</li>
            <li><strong>Diagrams Uploaded:</strong> <?php echo e($diagramCount); ?> diagrams</li>
        </ul>
    </div>

    
    <?php if($attendances->isNotEmpty()): ?>
    <div class="card recent-entries">
        <div class="card-header">📝 My Logbook Entries</div>

        <table class="table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Work Done</th>
                    <th>Diagram</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $logbookEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(\Carbon\Carbon::parse($entry->date)->format('D, M j, Y')); ?></td>
                    <td><?php echo e(\Illuminate\Support\Str::limit($entry->lesson_learned, 60)); ?></td>
                    <td>
                        <?php if($entry->diagram_path): ?>
                            <img src="<?php echo e(asset('storage/' . $entry->diagram_path)); ?>" alt="Diagram" width="80">
                        <?php else: ?>
                            <span class="text-muted">No Diagram</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php else: ?>
        <div class="alert alert-info">
            You don't have any logbook entries yet!
        </div>
    <?php endif; ?>

    
    <?php if($evaluation): ?>
    <div class="card">
        <div class="card-header">📋 Supervisor's Evaluation</div>
        <ul class="summary-list">
            <li><strong>Punctuality:</strong> <?php echo e($evaluation->punctuality); ?>/10</li>
            <li><strong>Attitude:</strong> <?php echo e($evaluation->attitude); ?>/10</li>
            <li><strong>Skill Acquisition:</strong> <?php echo e($evaluation->skill_acquisition); ?>/10</li>
            <li><strong>Report Quality:</strong> <?php echo e($evaluation->report_quality); ?>/10</li>
            <li><strong>Remarks:</strong> <?php echo e($evaluation->remarks ?? 'No remarks provided'); ?></li>
        </ul>
    </div>
    <?php endif; ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\user\Desktop\Laravel Projects\internmanager\resources\views/students/logbook.blade.php ENDPATH**/ ?>